package com.android.print.demo.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ThumbnailUtils;
import android.util.Log;

import com.android.print.demo.R;
import com.mht.print.sdk.Barcode;
import com.mht.print.sdk.CanvasPrint;
import com.mht.print.sdk.FontProperty;
import com.mht.print.sdk.PrinterConstants.BarcodeType;
import com.mht.print.sdk.PrinterConstants.Command;
import com.mht.print.sdk.PrinterInstance;
import com.mht.print.sdk.PrinterType;
import com.mht.print.sdk.Table;
import com.mht.print.sdk.util.Utils;

public class PrintUtils {

    private static final String TAG = PrintUtils.class.getSimpleName();

    public static Context context;

    public static void printText(Resources resources, PrinterInstance mPrinter) {
        // 初始化打印机
        // Initialize the printer
        mPrinter.init();
        mPrinter.printText(resources.getString(R.string.example_text));
        mPrinter.printText("\n");
    }

    public static void printNote(Resources resources, PrinterInstance mPrinter, boolean is58mm) {
        // 初始化打印机
        // Initialize the printer
        mPrinter.init();
        StringBuffer sb = new StringBuffer();
        // mPrinter.setPrinter(BluetoothPrinter.COMM_LINE_HEIGHT, 80);
        // 内容居中
        // Content centered
        mPrinter.setPrinter(Command.ALIGN, Command.ALIGN_CENTER);
        // 字号横向纵向扩大一倍（倍高倍宽）
        // The font size is doubled horizontally and vertically (double height and double width)
        mPrinter.setCharacterMultiple(1, 1);
        // 打印文本
        // Print text

        mPrinter.printText(resources.getString(R.string.shop_company_title)
                + "\n");
        // 内容居左
        // Content centered
        mPrinter.setPrinter(Command.ALIGN, Command.ALIGN_LEFT);
        // 字号使用默认
        // Use default font size
        mPrinter.setCharacterMultiple(0, 0);
        //加粗
        mPrinter.setPrinter(Command.SET_BOLD, 1);
        mPrinter.printText("Print Text\n");
        //取消加粗
        mPrinter.setPrinter(Command.SET_BOLD, 0);
        sb.append(resources.getString(R.string.shop_num)).append("574001\n");

        sb.append(resources.getString(R.string.shop_receipt_num)).append("S00003169\n");
        sb.append(resources.getString(R.string.shop_cashier_num)).append("s004_s004\n");
        sb.append(resources.getString(R.string.shop_receipt_date)).append("2012-06-17\n");
        sb.append(resources.getString(R.string.shop_print_time)).append("2012-06-17 13:37:24\n");
        // 打印文本
        // Print text
        mPrinter.printText(sb.toString());

        // 打印表格
        // Print Table
        printTable1(resources, mPrinter, is58mm);

        sb = new StringBuffer();
        if (is58mm) {
            sb.append(resources.getString(R.string.shop_goods_number)).append("                6.00\n");
            sb.append(resources.getString(R.string.shop_goods_total_price)).append("                35.00\n");
            sb.append(resources.getString(R.string.shop_payment)).append("                100.00\n");
            sb.append(resources.getString(R.string.shop_change)).append("                65.00\n");
        } else {
            sb.append(resources.getString(R.string.shop_goods_number)).append("                                6.00\n");
            sb.append(resources.getString(R.string.shop_goods_total_price)).append("                                35.00\n");
            sb.append(resources.getString(R.string.shop_payment)).append("                                100.00\n");
            sb.append(resources.getString(R.string.shop_change)).append("                                65.00\n");
        }

        sb.append(resources.getString(R.string.shop_company_name) + "\n");
        sb.append(resources.getString(R.string.shop_company_site)
                + "www.jiangsu1510.com\n");
        sb.append(resources.getString(R.string.shop_company_address) + "\n");
        sb.append(resources.getString(R.string.shop_company_tel)
                + "0574-88222999\n");
        sb.append(resources.getString(R.string.shop_Service_Line)
                + "4008-567-567 \n");
        if (is58mm) {
            sb.append("==============================\n");
        } else {
            sb.append("==============================================\n");
        }
        // 打印文本
        // Print Text
        mPrinter.printText(sb.toString());
        // 内容居中
        // Content centered
        mPrinter.setPrinter(Command.ALIGN, Command.ALIGN_CENTER);
        // 字体倍高
        // Font double height
        mPrinter.setCharacterMultiple(0, 1);
        // 打印文本
        // Print Text
        mPrinter.printText(resources.getString(R.string.shop_thanks) + "\n");
        // 打印文本
        // Print Text
        mPrinter.printText(resources.getString(R.string.shop_demo) + "\n\n\n");
        // 打印并走纸n行
        // Print and feed paper n lines
        mPrinter.printText("\n\n\n\n\n\n");
    }

    public static void printImage(Resources resources, PrinterInstance mPrinter, boolean isStylus) {
        // 初始化打印机
        // Initialize the printer
        mPrinter.init();
        Bitmap bitmap = BitmapFactory.decodeResource(resources,
                R.drawable.goodwork);
        // 打印图片
        // print picture
        mPrinter.printEscImage(bitmap);
        // 打印并走纸n行
        // print and feed the paper n lines
        mPrinter.printText("\n\n\n\n\n\n");
    }

    public static void printQRCode(Resources resources, PrinterInstance mPrinter) {
        // 初始化打印机
        // Initialize the printer
        mPrinter.init();
        Bitmap bitmap = BitmapFactory.decodeResource(resources,
                R.drawable.qrcode);
        // 打印图片
        // print picture
        mPrinter.printEscImage(bitmap);
        // 打印并走纸n行
        // print and feed the paper n lines
        mPrinter.printText("\n\n\n\n\n\n");
    }


    public static void printCustomImage(Resources resources,
                                        PrinterInstance mPrinter, boolean isStylus, boolean is58mm) {
        mPrinter.init();
        // TODO Auto-generated method stub

        CanvasPrint cp = new CanvasPrint();
        /*
         * 初始化画布，画布的宽度为变量，一般有两个选择： 1、58mm型号打印机实际可用是48mm，48*8=384px
         * 2、80mm型号打印机实际可用是72mm，72*8=576px 因为画布的高度是无限制的，但从内存分配方面考虑要小于4M比较合适，
         * 所以预置为宽度的5倍。 初始化画笔，默认属性有： 1、消除锯齿 2、设置画笔颜色为黑色
         */
        // init 方法包含cp.initCanvas(550)和cp.initPaint(), T9打印宽度为72mm,其他为47mm.
        if (is58mm) {
            cp.init(PrinterType.PRINTER_58mm);
        } else {
            cp.init(PrinterType.PRINTER_80mm);
        }
        // 非中文使用空格分隔单词
        cp.setUseSplit(true);
        //cp.setUseSplitAndString(true, " ");
        // 阿拉伯文靠右显示
        cp.setTextAlignRight(true);
        /*
         * 插入图片函数: drawImage(float x, float y, String path)
         * 其中(x,y)是指插入图片的左上顶点坐标。
         */
        FontProperty fp = new FontProperty();
        fp.setFont(false, false, false, false, 25, null);
        // 通过初始化的字体属性设置画笔
        cp.setFontProperty(fp);
        cp.drawText("Contains Arabic language:");
        // pg.drawText("温度的影响主要表现在两个方面温度的影响主要表现在两个方面温度的影响主要表现在两个方面温度的影响主要表现在两个方面");
        fp.setFont(false, false, false, false, 30, null);
        cp.setFontProperty(fp);
        cp.drawText("ومن تكهناته إيمانه بإستحالة قياس السرعة اللحظية للجسيمات متناهية الصغر والتي تهتز عشوائياً في مختلف الإتجاهات بما يعرف باسم الحركة البراونية، لكن بعد قرن من الزمان، تمكن عالم يدعى مارك رايزن من تفنيد هذه المقولة عملياً بمعمل أبحاثه بجامعة تكساس وإستطاع قياس السرعة اللحظية لتلك الجسيمات، في خضم إختباراته لقانون التوزع المتساوي الذي يقرر أن طاقة حركة الجسيم تعتمد على حرارته بشكل بحت وليس على على كتلته أو حجمه، ");
        cp.drawImage(BitmapFactory.decodeResource(resources,
                R.drawable.my_picture));

        mPrinter.printText("Print Custom Image:\n");
        mPrinter.printEscImage(cp.getCanvasImage());
        mPrinter.printText("\n\n\n\n\n\n");
    }

    public static void printTable(Resources resources, PrinterInstance mPrinter, boolean is58mm) {
        // 初始化打印机
        // Initialize the printer
        mPrinter.init();
        // getTable方法:参数1,以特定符号分隔的列名; 2,列名分隔符;
        // 3,各列所占字符宽度,中文2个,英文1个. 默认字体总共不要超过48
        // 表格超出部分会另起一行打印.若想手动换行,可加\n.
        // getTable method: parameter 1, column name separated by a specific symbol; 2, column name separator;
        // 3, the character width of each column, 2 Chinese and 1 English. The default font should not exceed 48 in total
        // The excess part of the table will be printed on a new line. If you want to manually wrap, you can add \n.
        // 设置字体大小
        // Set font size
        mPrinter.setCharacterMultiple(0, 1);
        mPrinter.printText("倍高字体\n");
        mPrinter.setCharacterMultiple(1, 1);
        mPrinter.printText("倍宽倍高字体\n");
        mPrinter.setCharacterMultiple(1, 0);
        mPrinter.printText("倍宽字体\n");
        mPrinter.setCharacterMultiple(0, 0);
        mPrinter.printText("正常字体\n\n");
        String column = resources.getString(R.string.note_title);
        // 表格初始化
        // Form initialization
        Table table;
        if (is58mm) {
            table = new Table(column, ";", new int[]{14, 6, 6, 6});
        } else {
            table = new Table(column, ";", new int[]{16, 8, 8, 12});
        }
        // 每列内容靠右
        // Right of each column
        table.setColumnAlignRight(true);
        table.addRow("1," + resources.getString(R.string.coffee)
                + ";2.00;5.00;10.00");
        table.addRow("2," + resources.getString(R.string.tableware)
                + ";2.00;5.00;10.00");
        table.addRow("3," + resources.getString(R.string.frog)
                + ";1.00;68.00;68.00");
        table.addRow("4," + resources.getString(R.string.cucumber)
                + ";1.00;4.00;4.00");
        table.addRow("5," + resources.getString(R.string.peanuts)
                + "; 1.00;5.00;5.00");
        table.addRow("6," + resources.getString(R.string.rice)
                + ";1.00;2.00;2.00");
        mPrinter.printTable(table);
        mPrinter.printText("\n\n");
        Barcode barcode = new Barcode(BarcodeType.CODE128, 5, 72, 2, "123456");
        mPrinter.printBarCode(barcode);
        mPrinter.printText("\n");
        // 打印并走纸n行
        // Print and feed paper n lines
        mPrinter.setPrinter(Command.ALIGN, Command.ALIGN_CENTER);
        Barcode qrCode = new Barcode(BarcodeType.QRCODE);
        qrCode.setQrcodeSize(6);
        qrCode.setBarcodeContent("123456");
        mPrinter.printBarCode(qrCode);
        mPrinter.printText("\n\n\n\n\n\n");
    }

    public static void
    printTable1(Resources resources,
                PrinterInstance mPrinter, boolean is58mm) {
        mPrinter.init();
        String column = resources.getString(R.string.note_title);
        Table table;
        if (is58mm) {
            table = new Table(column, ";", new int[]{14, 6, 6, 6});
        } else {
            table = new Table(column, ";", new int[]{18, 10, 10, 12});
        }
        table.addRow("" + resources.getString(R.string.bags) + ";10.00;1;10.00");
        table.addRow("" + resources.getString(R.string.hook) + ";5.00;2;10.00");
        table.addRow("" + resources.getString(R.string.umbrella)
                + ";5.00;3;15.00");
        mPrinter.printTable(table);
    }

    public static void printBarCode(PrinterInstance mPrinter) {
        // 初始化打印机
        // Initialize the printer
        mPrinter.init();
        // 字体默认大小
        // Default font size
        mPrinter.setCharacterMultiple(0, 0);

        //设置左边距,nL,nH 设置宽度为(nL+nH*256)* 横向移动单位. 设置左边距对打印条码的注释位置有影响.
        //Set the left margin, nL, nH, set the width to (nL+nH*256)* horizontal movement unit. Setting the left margin has an effect on the annotation position of the printed barcode.
        mPrinter.setLeftMargin(15, 0);
        // mPrinter.setPrinter(BluetoothPrinter.COMM_ALIGN,BluetoothPrinter.COMM_ALIGN_LEFT);

        /**
         * 参数1: 设置条码横向宽度 2<=n<=6,默认为2 参数2: 设置条码高度 1<=n<=255,默认162 参数3:
         * 设置条码注释打印位置.0不打印,1上方,2下方,3上下方均有,默认为0 参数4:
         * 设置条码类型.BluetoothPrinter.BAR_CODE_TYPE_ 开头的常量,默认为CODE128
         */
        /**
         * Parameter 1: Set the horizontal width of the bar code 2<=n<=6, the default is 2 Parameter 2: Set the bar code height 1<=n<=255, the default is 162 Parameter 3:
         * Set the barcode comment printing position. 0 does not print, 1 is above, 2 is below, 3 is both above and below, the default is 0 Parameter 4:
         * Set the barcode type. BluetoothPrinter.BAR_CODE_TYPE_ starts with a constant, the default is CODE128
         */
        Barcode barcode;
        mPrinter.printText("UPC_A\n");
        barcode = new Barcode(BarcodeType.UPC_A, 3, 72, 2, "123456789012");
        mPrinter.printBarCode(barcode);

        // JAN13(EAN13) 1234567
        mPrinter.printText("JAN13(EAN13)\n");
        barcode = new Barcode(BarcodeType.JAN13, 3, 72, 2, "123456789012");
        mPrinter.printBarCode(barcode);

        // JAN8(EAN8) 1234567
        mPrinter.printText("JAN8(EAN8)\n");
        barcode = new Barcode(BarcodeType.JAN8, 3, 72, 2, "1234567");
        mPrinter.printBarCode(barcode);

        // CODE39
        mPrinter.printText("CODE39\n");
        barcode = new Barcode(BarcodeType.CODE39, 3, 72, 2, "123456");
        mPrinter.printBarCode(barcode);

        // CODABAR
        mPrinter.printText("CODABAR\n");
        barcode = new Barcode(BarcodeType.CODABAR, 3, 72, 2, "123456");
        mPrinter.printBarCode(barcode);
        // CODE93
        mPrinter.printText("CODE93\n");
        barcode = new Barcode(BarcodeType.CODE93, 3, 72, 2, "123456");
        mPrinter.printBarCode(barcode);

        // Code128
        mPrinter.printText("CODE128\n");
        barcode = new Barcode(BarcodeType.CODE128, 2, 72, 2, "123456");
        mPrinter.printBarCode(barcode);

        mPrinter.printText("\n\n\n\n\n\n");
    }

    public static void printQRCode(PrinterInstance mPrinter) {
        mPrinter.init();
        //第一个参数二维码大小，部分机型生效
        //The first parameter QR code size, valid for some models
        Barcode barcode = new Barcode(BarcodeType.QRCODE);
        barcode.setQrcodeSize(5);
        barcode.setBarcodeContent("123456");
        mPrinter.printBarCode(barcode);
        mPrinter.printText("\n\n\n\n\n\n");
    }

    /**
     * 将彩色图转换为黑白图
     *
     * @param bmp 位图
     * @return 返回转换好的位图
     */
    /**
     * Convert color images to black and white images
     *
     * @param bmp bitmap
     * @return returns the converted bitmap
     */
    public static Bitmap convertToBlackWhite(Bitmap bmp) {
        // 获取位图的宽
        // Get the width of the bitmap
        int width = bmp.getWidth();
        // 获取位图的高
        // Get the height of the bitmap
        int height = bmp.getHeight();
        // 通过位图的大小创建像素点数组
        // Create an array of pixels by the size of the bitmap
        int[] pixels = new int[width * height];

        bmp.getPixels(pixels, 0, width, 0, 0, width, height);
        int alpha = 0xFF << 24;
        for (int i = 0; i < height; i++) {
            for (int j = 0; j < width; j++) {
                int grey = pixels[width * i + j];

                int red = ((grey & 0x00FF0000) >> 16);
                int green = ((grey & 0x0000FF00) >> 8);
                int blue = (grey & 0x000000FF);

                grey = (int) (red * 0.3 + green * 0.59 + blue * 0.11);
                grey = alpha | (grey << 16) | (grey << 8) | grey;
                pixels[width * i + j] = grey;
            }
        }
        Bitmap newBmp = Bitmap.createBitmap(width, height, Config.RGB_565);

        newBmp.setPixels(pixels, 0, width, 0, 0, width, height);

        return ThumbnailUtils.extractThumbnail(newBmp, 380, 460);
    }

    /**
     * 重置图片的尺寸
     * @param newWidth 新图片宽度
     * @param newHeight 新图片高度
     * @param bitmap 原图片
     * @param rotate 旋转角度
     * @return 重置后的图片
     */
    /**
     * Reset the size of the picture
     *
     * @param newWidth  new image width
     * @param newHeight new image height
     * @param bitmap    original image
     * @param rotate    rotation angle
     * @return picture after reset
     */
    public static Bitmap handleBitmap(float newWidth, float newHeight, Bitmap bitmap, int rotate) {

        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float scaleWidth = newWidth / width;
        float scaleHeight = newHeight / height;

        rotate = rotate % 360;

        if (rotate == 90 || rotate == 270) {
            float temp = scaleHeight;
            scaleHeight = scaleWidth;
            scaleWidth = temp;
        }

        Matrix matrix = new Matrix();

        if (rotate != 0) {
            matrix.setRotate(rotate, bitmap.getWidth() / 2, bitmap.getHeight() / 2);
        }
        matrix.postScale(scaleWidth, scaleHeight);
        bitmap = Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), matrix, true);
        return bitmap;
    }
}
